package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  ConfigurationSetName,
  AmazonResourceName,
  Address
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SendRawEmailRequest(
    source: Optional[Address] = Optional.Absent,
    destinations: Optional[Iterable[Address]] = Optional.Absent,
    rawMessage: zio.aws.ses.model.RawMessage,
    fromArn: Optional[AmazonResourceName] = Optional.Absent,
    sourceArn: Optional[AmazonResourceName] = Optional.Absent,
    returnPathArn: Optional[AmazonResourceName] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ses.model.MessageTag]] = Optional.Absent,
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendRawEmailRequest = {
    import SendRawEmailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendRawEmailRequest
      .builder()
      .optionallyWith(
        source.map(value => Address.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.destinations)
      .rawMessage(rawMessage.buildAwsValue())
      .optionallyWith(
        fromArn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.fromArn)
      .optionallyWith(
        sourceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(
        returnPathArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.returnPathArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SendRawEmailRequest.ReadOnly =
    zio.aws.ses.model.SendRawEmailRequest.wrap(buildAwsValue())
}
object SendRawEmailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SendRawEmailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendRawEmailRequest =
      zio.aws.ses.model.SendRawEmailRequest(
        source.map(value => value),
        destinations.map(value => value),
        rawMessage.asEditable,
        fromArn.map(value => value),
        sourceArn.map(value => value),
        returnPathArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationSetName.map(value => value)
      )
    def source: Optional[Address]
    def destinations: Optional[List[Address]]
    def rawMessage: zio.aws.ses.model.RawMessage.ReadOnly
    def fromArn: Optional[AmazonResourceName]
    def sourceArn: Optional[AmazonResourceName]
    def returnPathArn: Optional[AmazonResourceName]
    def tags: Optional[List[zio.aws.ses.model.MessageTag.ReadOnly]]
    def configurationSetName: Optional[ConfigurationSetName]
    def getSource: ZIO[Any, AwsError, Address] =
      AwsError.unwrapOptionField("source", source)
    def getDestinations: ZIO[Any, AwsError, List[Address]] =
      AwsError.unwrapOptionField("destinations", destinations)
    def getRawMessage
        : ZIO[Any, Nothing, zio.aws.ses.model.RawMessage.ReadOnly] =
      ZIO.succeed(rawMessage)
    def getFromArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("fromArn", fromArn)
    def getSourceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getReturnPathArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("returnPathArn", returnPathArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.ses.model.MessageTag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendRawEmailRequest
  ) extends zio.aws.ses.model.SendRawEmailRequest.ReadOnly {
    override val source: Optional[Address] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => zio.aws.ses.model.primitives.Address(value))
    override val destinations: Optional[List[Address]] = zio.aws.core.internal
      .optionalFromNullable(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.primitives.Address(item)
        }.toList
      )
    override val rawMessage: zio.aws.ses.model.RawMessage.ReadOnly =
      zio.aws.ses.model.RawMessage.wrap(impl.rawMessage())
    override val fromArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.fromArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val sourceArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val returnPathArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnPathArn())
        .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val tags: Optional[List[zio.aws.ses.model.MessageTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ses.model.MessageTag.wrap(item)
          }.toList
        )
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value => zio.aws.ses.model.primitives.ConfigurationSetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendRawEmailRequest
  ): zio.aws.ses.model.SendRawEmailRequest.ReadOnly = new Wrapper(impl)
}
