package zio.aws.ses.model
import zio.aws.ses.model.primitives.MessageId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SendRawEmailResponse(messageId: MessageId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendRawEmailResponse = {
    import SendRawEmailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendRawEmailResponse
      .builder()
      .messageId(MessageId.unwrap(messageId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SendRawEmailResponse.ReadOnly =
    zio.aws.ses.model.SendRawEmailResponse.wrap(buildAwsValue())
}
object SendRawEmailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SendRawEmailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendRawEmailResponse =
      zio.aws.ses.model.SendRawEmailResponse(messageId)
    def messageId: MessageId
    def getMessageId: ZIO[Any, Nothing, MessageId] = ZIO.succeed(messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendRawEmailResponse
  ) extends zio.aws.ses.model.SendRawEmailResponse.ReadOnly {
    override val messageId: MessageId =
      zio.aws.ses.model.primitives.MessageId(impl.messageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendRawEmailResponse
  ): zio.aws.ses.model.SendRawEmailResponse.ReadOnly = new Wrapper(impl)
}
