package zio.aws.ses.model
import zio.aws.ses.model.primitives.{Enabled, Identity}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SetIdentityFeedbackForwardingEnabledRequest(
    identity: Identity,
    forwardingEnabled: Enabled
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest = {
    import SetIdentityFeedbackForwardingEnabledRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest
      .builder()
      .identity(Identity.unwrap(identity): java.lang.String)
      .forwardingEnabled(Enabled.unwrap(forwardingEnabled): java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.SetIdentityFeedbackForwardingEnabledRequest.ReadOnly =
    zio.aws.ses.model.SetIdentityFeedbackForwardingEnabledRequest
      .wrap(buildAwsValue())
}
object SetIdentityFeedbackForwardingEnabledRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.SetIdentityFeedbackForwardingEnabledRequest =
      zio.aws.ses.model.SetIdentityFeedbackForwardingEnabledRequest(
        identity,
        forwardingEnabled
      )
    def identity: Identity
    def forwardingEnabled: Enabled
    def getIdentity: ZIO[Any, Nothing, Identity] = ZIO.succeed(identity)
    def getForwardingEnabled: ZIO[Any, Nothing, Enabled] =
      ZIO.succeed(forwardingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest
  ) extends zio.aws.ses.model.SetIdentityFeedbackForwardingEnabledRequest.ReadOnly {
    override val identity: Identity =
      zio.aws.ses.model.primitives.Identity(impl.identity())
    override val forwardingEnabled: Enabled =
      zio.aws.ses.model.primitives.Enabled(impl.forwardingEnabled())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SetIdentityFeedbackForwardingEnabledRequest
  ): zio.aws.ses.model.SetIdentityFeedbackForwardingEnabledRequest.ReadOnly =
    new Wrapper(impl)
}
