package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  HtmlPart,
  TextPart,
  SubjectPart,
  TemplateName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Template(
    templateName: TemplateName,
    subjectPart: Optional[SubjectPart] = Optional.Absent,
    textPart: Optional[TextPart] = Optional.Absent,
    htmlPart: Optional[HtmlPart] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ses.model.Template = {
    import Template.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.Template
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .optionallyWith(
        subjectPart.map(value => SubjectPart.unwrap(value): java.lang.String)
      )(_.subjectPart)
      .optionallyWith(
        textPart.map(value => TextPart.unwrap(value): java.lang.String)
      )(_.textPart)
      .optionallyWith(
        htmlPart.map(value => HtmlPart.unwrap(value): java.lang.String)
      )(_.htmlPart)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.Template.ReadOnly =
    zio.aws.ses.model.Template.wrap(buildAwsValue())
}
object Template {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.Template] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.Template = zio.aws.ses.model.Template(
      templateName,
      subjectPart.map(value => value),
      textPart.map(value => value),
      htmlPart.map(value => value)
    )
    def templateName: TemplateName
    def subjectPart: Optional[SubjectPart]
    def textPart: Optional[TextPart]
    def htmlPart: Optional[HtmlPart]
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
    def getSubjectPart: ZIO[Any, AwsError, SubjectPart] =
      AwsError.unwrapOptionField("subjectPart", subjectPart)
    def getTextPart: ZIO[Any, AwsError, TextPart] =
      AwsError.unwrapOptionField("textPart", textPart)
    def getHtmlPart: ZIO[Any, AwsError, HtmlPart] =
      AwsError.unwrapOptionField("htmlPart", htmlPart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.Template
  ) extends zio.aws.ses.model.Template.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.ses.model.primitives.TemplateName(impl.templateName())
    override val subjectPart: Optional[SubjectPart] = zio.aws.core.internal
      .optionalFromNullable(impl.subjectPart())
      .map(value => zio.aws.ses.model.primitives.SubjectPart(value))
    override val textPart: Optional[TextPart] = zio.aws.core.internal
      .optionalFromNullable(impl.textPart())
      .map(value => zio.aws.ses.model.primitives.TextPart(value))
    override val htmlPart: Optional[HtmlPart] = zio.aws.core.internal
      .optionalFromNullable(impl.htmlPart())
      .map(value => zio.aws.ses.model.primitives.HtmlPart(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.Template
  ): zio.aws.ses.model.Template.ReadOnly = new Wrapper(impl)
}
