package zio.aws.ses.model
import zio.aws.ses.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateConfigurationSetEventDestinationRequest(
    configurationSetName: ConfigurationSetName,
    eventDestination: zio.aws.ses.model.EventDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationRequest = {
    import UpdateConfigurationSetEventDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .eventDestination(eventDestination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.UpdateConfigurationSetEventDestinationRequest.ReadOnly =
    zio.aws.ses.model.UpdateConfigurationSetEventDestinationRequest
      .wrap(buildAwsValue())
}
object UpdateConfigurationSetEventDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.UpdateConfigurationSetEventDestinationRequest =
      zio.aws.ses.model.UpdateConfigurationSetEventDestinationRequest(
        configurationSetName,
        eventDestination.asEditable
      )
    def configurationSetName: ConfigurationSetName
    def eventDestination: zio.aws.ses.model.EventDestination.ReadOnly
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getEventDestination
        : ZIO[Any, Nothing, zio.aws.ses.model.EventDestination.ReadOnly] =
      ZIO.succeed(eventDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationRequest
  ) extends zio.aws.ses.model.UpdateConfigurationSetEventDestinationRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.ses.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val eventDestination: zio.aws.ses.model.EventDestination.ReadOnly =
      zio.aws.ses.model.EventDestination.wrap(impl.eventDestination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationRequest
  ): zio.aws.ses.model.UpdateConfigurationSetEventDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
