package zio.aws.ses.model
import zio.aws.ses.model.primitives.{Enabled, ConfigurationSetName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateConfigurationSetSendingEnabledRequest(
    configurationSetName: ConfigurationSetName,
    enabled: Enabled
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledRequest = {
    import UpdateConfigurationSetSendingEnabledRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .enabled(Enabled.unwrap(enabled): java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.UpdateConfigurationSetSendingEnabledRequest.ReadOnly =
    zio.aws.ses.model.UpdateConfigurationSetSendingEnabledRequest
      .wrap(buildAwsValue())
}
object UpdateConfigurationSetSendingEnabledRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.UpdateConfigurationSetSendingEnabledRequest =
      zio.aws.ses.model.UpdateConfigurationSetSendingEnabledRequest(
        configurationSetName,
        enabled
      )
    def configurationSetName: ConfigurationSetName
    def enabled: Enabled
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getEnabled: ZIO[Any, Nothing, Enabled] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledRequest
  ) extends zio.aws.ses.model.UpdateConfigurationSetSendingEnabledRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.ses.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val enabled: Enabled =
      zio.aws.ses.model.primitives.Enabled(impl.enabled())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.UpdateConfigurationSetSendingEnabledRequest
  ): zio.aws.ses.model.UpdateConfigurationSetSendingEnabledRequest.ReadOnly =
    new Wrapper(impl)
}
