package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  TemplateName,
  FromAddress,
  TemplateContent,
  FailureRedirectionURL,
  SuccessRedirectionURL,
  Subject
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateCustomVerificationEmailTemplateRequest(
    templateName: TemplateName,
    fromEmailAddress: Optional[FromAddress] = Optional.Absent,
    templateSubject: Optional[Subject] = Optional.Absent,
    templateContent: Optional[TemplateContent] = Optional.Absent,
    successRedirectionURL: Optional[SuccessRedirectionURL] = Optional.Absent,
    failureRedirectionURL: Optional[FailureRedirectionURL] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest = {
    import UpdateCustomVerificationEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .optionallyWith(
        fromEmailAddress.map(value =>
          FromAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .optionallyWith(
        templateSubject.map(value => Subject.unwrap(value): java.lang.String)
      )(_.templateSubject)
      .optionallyWith(
        templateContent.map(value =>
          TemplateContent.unwrap(value): java.lang.String
        )
      )(_.templateContent)
      .optionallyWith(
        successRedirectionURL.map(value =>
          SuccessRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.successRedirectionURL)
      .optionallyWith(
        failureRedirectionURL.map(value =>
          FailureRedirectionURL.unwrap(value): java.lang.String
        )
      )(_.failureRedirectionURL)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.UpdateCustomVerificationEmailTemplateRequest.ReadOnly =
    zio.aws.ses.model.UpdateCustomVerificationEmailTemplateRequest
      .wrap(buildAwsValue())
}
object UpdateCustomVerificationEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.UpdateCustomVerificationEmailTemplateRequest =
      zio.aws.ses.model.UpdateCustomVerificationEmailTemplateRequest(
        templateName,
        fromEmailAddress.map(value => value),
        templateSubject.map(value => value),
        templateContent.map(value => value),
        successRedirectionURL.map(value => value),
        failureRedirectionURL.map(value => value)
      )
    def templateName: TemplateName
    def fromEmailAddress: Optional[FromAddress]
    def templateSubject: Optional[Subject]
    def templateContent: Optional[TemplateContent]
    def successRedirectionURL: Optional[SuccessRedirectionURL]
    def failureRedirectionURL: Optional[FailureRedirectionURL]
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
    def getFromEmailAddress: ZIO[Any, AwsError, FromAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getTemplateSubject: ZIO[Any, AwsError, Subject] =
      AwsError.unwrapOptionField("templateSubject", templateSubject)
    def getTemplateContent: ZIO[Any, AwsError, TemplateContent] =
      AwsError.unwrapOptionField("templateContent", templateContent)
    def getSuccessRedirectionURL: ZIO[Any, AwsError, SuccessRedirectionURL] =
      AwsError.unwrapOptionField("successRedirectionURL", successRedirectionURL)
    def getFailureRedirectionURL: ZIO[Any, AwsError, FailureRedirectionURL] =
      AwsError.unwrapOptionField("failureRedirectionURL", failureRedirectionURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest
  ) extends zio.aws.ses.model.UpdateCustomVerificationEmailTemplateRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.ses.model.primitives.TemplateName(impl.templateName())
    override val fromEmailAddress: Optional[FromAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.fromEmailAddress())
      .map(value => zio.aws.ses.model.primitives.FromAddress(value))
    override val templateSubject: Optional[Subject] = zio.aws.core.internal
      .optionalFromNullable(impl.templateSubject())
      .map(value => zio.aws.ses.model.primitives.Subject(value))
    override val templateContent: Optional[TemplateContent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateContent())
        .map(value => zio.aws.ses.model.primitives.TemplateContent(value))
    override val successRedirectionURL: Optional[SuccessRedirectionURL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.successRedirectionURL())
        .map(value => zio.aws.ses.model.primitives.SuccessRedirectionURL(value))
    override val failureRedirectionURL: Optional[FailureRedirectionURL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureRedirectionURL())
        .map(value => zio.aws.ses.model.primitives.FailureRedirectionURL(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.UpdateCustomVerificationEmailTemplateRequest
  ): zio.aws.ses.model.UpdateCustomVerificationEmailTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
