package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateTemplateRequest(template: zio.aws.ses.model.Template) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.UpdateTemplateRequest = {
    import UpdateTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.UpdateTemplateRequest
      .builder()
      .template(template.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ses.model.UpdateTemplateRequest.ReadOnly =
    zio.aws.ses.model.UpdateTemplateRequest.wrap(buildAwsValue())
}
object UpdateTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.UpdateTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.UpdateTemplateRequest =
      zio.aws.ses.model.UpdateTemplateRequest(template.asEditable)
    def template: zio.aws.ses.model.Template.ReadOnly
    def getTemplate: ZIO[Any, Nothing, zio.aws.ses.model.Template.ReadOnly] =
      ZIO.succeed(template)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.UpdateTemplateRequest
  ) extends zio.aws.ses.model.UpdateTemplateRequest.ReadOnly {
    override val template: zio.aws.ses.model.Template.ReadOnly =
      zio.aws.ses.model.Template.wrap(impl.template())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.UpdateTemplateRequest
  ): zio.aws.ses.model.UpdateTemplateRequest.ReadOnly = new Wrapper(impl)
}
