package zio.aws.ses.model
import zio.aws.ses.model.primitives.Domain
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VerifyDomainIdentityRequest(domain: Domain) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.VerifyDomainIdentityRequest = {
    import VerifyDomainIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.VerifyDomainIdentityRequest
      .builder()
      .domain(Domain.unwrap(domain): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.VerifyDomainIdentityRequest.ReadOnly =
    zio.aws.ses.model.VerifyDomainIdentityRequest.wrap(buildAwsValue())
}
object VerifyDomainIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.VerifyDomainIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.VerifyDomainIdentityRequest =
      zio.aws.ses.model.VerifyDomainIdentityRequest(domain)
    def domain: Domain
    def getDomain: ZIO[Any, Nothing, Domain] = ZIO.succeed(domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.VerifyDomainIdentityRequest
  ) extends zio.aws.ses.model.VerifyDomainIdentityRequest.ReadOnly {
    override val domain: Domain =
      zio.aws.ses.model.primitives.Domain(impl.domain())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.VerifyDomainIdentityRequest
  ): zio.aws.ses.model.VerifyDomainIdentityRequest.ReadOnly = new Wrapper(impl)
}
