package zio.aws.ses.model
import zio.aws.ses.model.primitives.VerificationToken
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VerifyDomainIdentityResponse(
    verificationToken: VerificationToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.VerifyDomainIdentityResponse = {
    import VerifyDomainIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.VerifyDomainIdentityResponse
      .builder()
      .verificationToken(
        VerificationToken.unwrap(verificationToken): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.VerifyDomainIdentityResponse.ReadOnly =
    zio.aws.ses.model.VerifyDomainIdentityResponse.wrap(buildAwsValue())
}
object VerifyDomainIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.VerifyDomainIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.VerifyDomainIdentityResponse =
      zio.aws.ses.model.VerifyDomainIdentityResponse(verificationToken)
    def verificationToken: VerificationToken
    def getVerificationToken: ZIO[Any, Nothing, VerificationToken] =
      ZIO.succeed(verificationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.VerifyDomainIdentityResponse
  ) extends zio.aws.ses.model.VerifyDomainIdentityResponse.ReadOnly {
    override val verificationToken: VerificationToken =
      zio.aws.ses.model.primitives.VerificationToken(impl.verificationToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.VerifyDomainIdentityResponse
  ): zio.aws.ses.model.VerifyDomainIdentityResponse.ReadOnly = new Wrapper(impl)
}
