package zio.aws.ses.model
import zio.aws.ses.model.primitives.Address
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VerifyEmailIdentityRequest(emailAddress: Address) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.VerifyEmailIdentityRequest = {
    import VerifyEmailIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.VerifyEmailIdentityRequest
      .builder()
      .emailAddress(Address.unwrap(emailAddress): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.VerifyEmailIdentityRequest.ReadOnly =
    zio.aws.ses.model.VerifyEmailIdentityRequest.wrap(buildAwsValue())
}
object VerifyEmailIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.VerifyEmailIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.VerifyEmailIdentityRequest =
      zio.aws.ses.model.VerifyEmailIdentityRequest(emailAddress)
    def emailAddress: Address
    def getEmailAddress: ZIO[Any, Nothing, Address] = ZIO.succeed(emailAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.VerifyEmailIdentityRequest
  ) extends zio.aws.ses.model.VerifyEmailIdentityRequest.ReadOnly {
    override val emailAddress: Address =
      zio.aws.ses.model.primitives.Address(impl.emailAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.VerifyEmailIdentityRequest
  ): zio.aws.ses.model.VerifyEmailIdentityRequest.ReadOnly = new Wrapper(impl)
}
