package zio.aws.ses.model
import zio.aws.ses.model.primitives.{AmazonResourceName, Address}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BouncedRecipientInfo(
    recipient: Address,
    recipientArn: Optional[AmazonResourceName] = Optional.Absent,
    bounceType: Optional[zio.aws.ses.model.BounceType] = Optional.Absent,
    recipientDsnFields: Optional[zio.aws.ses.model.RecipientDsnFields] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.BouncedRecipientInfo = {
    import BouncedRecipientInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.BouncedRecipientInfo
      .builder()
      .recipient(Address.unwrap(recipient): java.lang.String)
      .optionallyWith(
        recipientArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.recipientArn)
      .optionallyWith(bounceType.map(value => value.unwrap))(_.bounceType)
      .optionallyWith(recipientDsnFields.map(value => value.buildAwsValue()))(
        _.recipientDsnFields
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.BouncedRecipientInfo.ReadOnly =
    zio.aws.ses.model.BouncedRecipientInfo.wrap(buildAwsValue())
}
object BouncedRecipientInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.BouncedRecipientInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.BouncedRecipientInfo =
      zio.aws.ses.model.BouncedRecipientInfo(
        recipient,
        recipientArn.map(value => value),
        bounceType.map(value => value),
        recipientDsnFields.map(value => value.asEditable)
      )
    def recipient: Address
    def recipientArn: Optional[AmazonResourceName]
    def bounceType: Optional[zio.aws.ses.model.BounceType]
    def recipientDsnFields
        : Optional[zio.aws.ses.model.RecipientDsnFields.ReadOnly]
    def getRecipient: ZIO[Any, Nothing, Address] = ZIO.succeed(recipient)
    def getRecipientArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("recipientArn", recipientArn)
    def getBounceType: ZIO[Any, AwsError, zio.aws.ses.model.BounceType] =
      AwsError.unwrapOptionField("bounceType", bounceType)
    def getRecipientDsnFields
        : ZIO[Any, AwsError, zio.aws.ses.model.RecipientDsnFields.ReadOnly] =
      AwsError.unwrapOptionField("recipientDsnFields", recipientDsnFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.BouncedRecipientInfo
  ) extends zio.aws.ses.model.BouncedRecipientInfo.ReadOnly {
    override val recipient: Address =
      zio.aws.ses.model.primitives.Address(impl.recipient())
    override val recipientArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recipientArn())
        .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val bounceType: Optional[zio.aws.ses.model.BounceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bounceType())
        .map(value => zio.aws.ses.model.BounceType.wrap(value))
    override val recipientDsnFields
        : Optional[zio.aws.ses.model.RecipientDsnFields.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recipientDsnFields())
        .map(value => zio.aws.ses.model.RecipientDsnFields.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.BouncedRecipientInfo
  ): zio.aws.ses.model.BouncedRecipientInfo.ReadOnly = new Wrapper(impl)
}
