package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateTemplateRequest(template: zio.aws.ses.model.Template) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.CreateTemplateRequest = {
    import CreateTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.CreateTemplateRequest
      .builder()
      .template(template.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ses.model.CreateTemplateRequest.ReadOnly =
    zio.aws.ses.model.CreateTemplateRequest.wrap(buildAwsValue())
}
object CreateTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.CreateTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.CreateTemplateRequest =
      zio.aws.ses.model.CreateTemplateRequest(template.asEditable)
    def template: zio.aws.ses.model.Template.ReadOnly
    def getTemplate: ZIO[Any, Nothing, zio.aws.ses.model.Template.ReadOnly] =
      ZIO.succeed(template)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.CreateTemplateRequest
  ) extends zio.aws.ses.model.CreateTemplateRequest.ReadOnly {
    override val template: zio.aws.ses.model.Template.ReadOnly =
      zio.aws.ses.model.Template.wrap(impl.template())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.CreateTemplateRequest
  ): zio.aws.ses.model.CreateTemplateRequest.ReadOnly = new Wrapper(impl)
}
