package zio.aws.ses.model
import zio.aws.ses.model.primitives.Identity
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetIdentityVerificationAttributesResponse(
    verificationAttributes: Map[
      Identity,
      zio.aws.ses.model.IdentityVerificationAttributes
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesResponse = {
    import GetIdentityVerificationAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesResponse
      .builder()
      .verificationAttributes(
        verificationAttributes
          .map({ case (key, value) =>
            (Identity.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.GetIdentityVerificationAttributesResponse.ReadOnly =
    zio.aws.ses.model.GetIdentityVerificationAttributesResponse
      .wrap(buildAwsValue())
}
object GetIdentityVerificationAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.GetIdentityVerificationAttributesResponse =
      zio.aws.ses.model
        .GetIdentityVerificationAttributesResponse(verificationAttributes.map({
          case (key, value) =>
            key -> value.asEditable
        }))
    def verificationAttributes: Map[
      Identity,
      zio.aws.ses.model.IdentityVerificationAttributes.ReadOnly
    ]
    def getVerificationAttributes: ZIO[Any, Nothing, Map[
      Identity,
      zio.aws.ses.model.IdentityVerificationAttributes.ReadOnly
    ]] = ZIO.succeed(verificationAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesResponse
  ) extends zio.aws.ses.model.GetIdentityVerificationAttributesResponse.ReadOnly {
    override val verificationAttributes: Map[
      Identity,
      zio.aws.ses.model.IdentityVerificationAttributes.ReadOnly
    ] = impl
      .verificationAttributes()
      .asScala
      .map({ case (key, value) =>
        zio.aws.ses.model.primitives.Identity(
          key
        ) -> zio.aws.ses.model.IdentityVerificationAttributes.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesResponse
  ): zio.aws.ses.model.GetIdentityVerificationAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
