package zio.aws.ses.model
import scala.jdk.CollectionConverters.*
sealed trait IdentityType {
  def unwrap: software.amazon.awssdk.services.ses.model.IdentityType
}
object IdentityType {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.IdentityType
  ): zio.aws.ses.model.IdentityType = value match {
    case software.amazon.awssdk.services.ses.model.IdentityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.IdentityType.EMAIL_ADDRESS =>
      val r = EmailAddress
      r
    case software.amazon.awssdk.services.ses.model.IdentityType.DOMAIN =>
      val r = Domain
      r
  }
  case object unknownToSdkVersion extends zio.aws.ses.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.IdentityType =
      software.amazon.awssdk.services.ses.model.IdentityType.UNKNOWN_TO_SDK_VERSION
  }
  case object EmailAddress extends zio.aws.ses.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.IdentityType =
      software.amazon.awssdk.services.ses.model.IdentityType.EMAIL_ADDRESS
  }
  case object Domain extends zio.aws.ses.model.IdentityType {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.IdentityType =
      software.amazon.awssdk.services.ses.model.IdentityType.DOMAIN
  }
}
