package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  S3KeyPrefix,
  S3BucketName,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3Action(
    topicArn: Optional[AmazonResourceName] = Optional.Absent,
    bucketName: S3BucketName,
    objectKeyPrefix: Optional[S3KeyPrefix] = Optional.Absent,
    kmsKeyArn: Optional[AmazonResourceName] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ses.model.S3Action = {
    import S3Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.S3Action
      .builder()
      .optionallyWith(
        topicArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.topicArn)
      .bucketName(S3BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        objectKeyPrefix.map(value =>
          S3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.objectKeyPrefix)
      .optionallyWith(
        kmsKeyArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.S3Action.ReadOnly =
    zio.aws.ses.model.S3Action.wrap(buildAwsValue())
}
object S3Action {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.S3Action] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.S3Action = zio.aws.ses.model.S3Action(
      topicArn.map(value => value),
      bucketName,
      objectKeyPrefix.map(value => value),
      kmsKeyArn.map(value => value)
    )
    def topicArn: Optional[AmazonResourceName]
    def bucketName: S3BucketName
    def objectKeyPrefix: Optional[S3KeyPrefix]
    def kmsKeyArn: Optional[AmazonResourceName]
    def getTopicArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("topicArn", topicArn)
    def getBucketName: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucketName)
    def getObjectKeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("objectKeyPrefix", objectKeyPrefix)
    def getKmsKeyArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.S3Action
  ) extends zio.aws.ses.model.S3Action.ReadOnly {
    override val topicArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.topicArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val bucketName: S3BucketName =
      zio.aws.ses.model.primitives.S3BucketName(impl.bucketName())
    override val objectKeyPrefix: Optional[S3KeyPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.objectKeyPrefix())
      .map(value => zio.aws.ses.model.primitives.S3KeyPrefix(value))
    override val kmsKeyArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.S3Action
  ): zio.aws.ses.model.S3Action.ReadOnly = new Wrapper(impl)
}
