package zio.aws.ses.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ses.model.primitives.{Counter, Timestamp}
import scala.jdk.CollectionConverters.*
final case class SendDataPoint(
    timestamp: Optional[Timestamp] = Optional.Absent,
    deliveryAttempts: Optional[Counter] = Optional.Absent,
    bounces: Optional[Counter] = Optional.Absent,
    complaints: Optional[Counter] = Optional.Absent,
    rejects: Optional[Counter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendDataPoint = {
    import SendDataPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendDataPoint
      .builder()
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(
        deliveryAttempts.map(value => Counter.unwrap(value): java.lang.Long)
      )(_.deliveryAttempts)
      .optionallyWith(
        bounces.map(value => Counter.unwrap(value): java.lang.Long)
      )(_.bounces)
      .optionallyWith(
        complaints.map(value => Counter.unwrap(value): java.lang.Long)
      )(_.complaints)
      .optionallyWith(
        rejects.map(value => Counter.unwrap(value): java.lang.Long)
      )(_.rejects)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SendDataPoint.ReadOnly =
    zio.aws.ses.model.SendDataPoint.wrap(buildAwsValue())
}
object SendDataPoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.SendDataPoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendDataPoint =
      zio.aws.ses.model.SendDataPoint(
        timestamp.map(value => value),
        deliveryAttempts.map(value => value),
        bounces.map(value => value),
        complaints.map(value => value),
        rejects.map(value => value)
      )
    def timestamp: Optional[Timestamp]
    def deliveryAttempts: Optional[Counter]
    def bounces: Optional[Counter]
    def complaints: Optional[Counter]
    def rejects: Optional[Counter]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getDeliveryAttempts: ZIO[Any, AwsError, Counter] =
      AwsError.unwrapOptionField("deliveryAttempts", deliveryAttempts)
    def getBounces: ZIO[Any, AwsError, Counter] =
      AwsError.unwrapOptionField("bounces", bounces)
    def getComplaints: ZIO[Any, AwsError, Counter] =
      AwsError.unwrapOptionField("complaints", complaints)
    def getRejects: ZIO[Any, AwsError, Counter] =
      AwsError.unwrapOptionField("rejects", rejects)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendDataPoint
  ) extends zio.aws.ses.model.SendDataPoint.ReadOnly {
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.ses.model.primitives.Timestamp(value))
    override val deliveryAttempts: Optional[Counter] = zio.aws.core.internal
      .optionalFromNullable(impl.deliveryAttempts())
      .map(value => zio.aws.ses.model.primitives.Counter(value))
    override val bounces: Optional[Counter] = zio.aws.core.internal
      .optionalFromNullable(impl.bounces())
      .map(value => zio.aws.ses.model.primitives.Counter(value))
    override val complaints: Optional[Counter] = zio.aws.core.internal
      .optionalFromNullable(impl.complaints())
      .map(value => zio.aws.ses.model.primitives.Counter(value))
    override val rejects: Optional[Counter] = zio.aws.core.internal
      .optionalFromNullable(impl.rejects())
      .map(value => zio.aws.ses.model.primitives.Counter(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendDataPoint
  ): zio.aws.ses.model.SendDataPoint.ReadOnly = new Wrapper(impl)
}
