package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  TemplateData,
  ConfigurationSetName,
  TemplateName,
  AmazonResourceName,
  Address
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SendTemplatedEmailRequest(
    source: Address,
    destination: zio.aws.ses.model.Destination,
    replyToAddresses: Optional[Iterable[Address]] = Optional.Absent,
    returnPath: Optional[Address] = Optional.Absent,
    sourceArn: Optional[AmazonResourceName] = Optional.Absent,
    returnPathArn: Optional[AmazonResourceName] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ses.model.MessageTag]] = Optional.Absent,
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent,
    template: TemplateName,
    templateArn: Optional[AmazonResourceName] = Optional.Absent,
    templateData: TemplateData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendTemplatedEmailRequest = {
    import SendTemplatedEmailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendTemplatedEmailRequest
      .builder()
      .source(Address.unwrap(source): java.lang.String)
      .destination(destination.buildAwsValue())
      .optionallyWith(
        replyToAddresses.map(value =>
          value.map { item =>
            Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replyToAddresses)
      .optionallyWith(
        returnPath.map(value => Address.unwrap(value): java.lang.String)
      )(_.returnPath)
      .optionallyWith(
        sourceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(
        returnPathArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.returnPathArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .template(TemplateName.unwrap(template): java.lang.String)
      .optionallyWith(
        templateArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.templateArn)
      .templateData(TemplateData.unwrap(templateData): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SendTemplatedEmailRequest.ReadOnly =
    zio.aws.ses.model.SendTemplatedEmailRequest.wrap(buildAwsValue())
}
object SendTemplatedEmailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SendTemplatedEmailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendTemplatedEmailRequest =
      zio.aws.ses.model.SendTemplatedEmailRequest(
        source,
        destination.asEditable,
        replyToAddresses.map(value => value),
        returnPath.map(value => value),
        sourceArn.map(value => value),
        returnPathArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationSetName.map(value => value),
        template,
        templateArn.map(value => value),
        templateData
      )
    def source: Address
    def destination: zio.aws.ses.model.Destination.ReadOnly
    def replyToAddresses: Optional[List[Address]]
    def returnPath: Optional[Address]
    def sourceArn: Optional[AmazonResourceName]
    def returnPathArn: Optional[AmazonResourceName]
    def tags: Optional[List[zio.aws.ses.model.MessageTag.ReadOnly]]
    def configurationSetName: Optional[ConfigurationSetName]
    def template: TemplateName
    def templateArn: Optional[AmazonResourceName]
    def templateData: TemplateData
    def getSource: ZIO[Any, Nothing, Address] = ZIO.succeed(source)
    def getDestination
        : ZIO[Any, Nothing, zio.aws.ses.model.Destination.ReadOnly] =
      ZIO.succeed(destination)
    def getReplyToAddresses: ZIO[Any, AwsError, List[Address]] =
      AwsError.unwrapOptionField("replyToAddresses", replyToAddresses)
    def getReturnPath: ZIO[Any, AwsError, Address] =
      AwsError.unwrapOptionField("returnPath", returnPath)
    def getSourceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getReturnPathArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("returnPathArn", returnPathArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.ses.model.MessageTag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
    def getTemplate: ZIO[Any, Nothing, TemplateName] = ZIO.succeed(template)
    def getTemplateArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getTemplateData: ZIO[Any, Nothing, TemplateData] =
      ZIO.succeed(templateData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendTemplatedEmailRequest
  ) extends zio.aws.ses.model.SendTemplatedEmailRequest.ReadOnly {
    override val source: Address =
      zio.aws.ses.model.primitives.Address(impl.source())
    override val destination: zio.aws.ses.model.Destination.ReadOnly =
      zio.aws.ses.model.Destination.wrap(impl.destination())
    override val replyToAddresses: Optional[List[Address]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replyToAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ses.model.primitives.Address(item)
          }.toList
        )
    override val returnPath: Optional[Address] = zio.aws.core.internal
      .optionalFromNullable(impl.returnPath())
      .map(value => zio.aws.ses.model.primitives.Address(value))
    override val sourceArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val returnPathArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnPathArn())
        .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val tags: Optional[List[zio.aws.ses.model.MessageTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ses.model.MessageTag.wrap(item)
          }.toList
        )
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value => zio.aws.ses.model.primitives.ConfigurationSetName(value))
    override val template: TemplateName =
      zio.aws.ses.model.primitives.TemplateName(impl.template())
    override val templateArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateArn())
        .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val templateData: TemplateData =
      zio.aws.ses.model.primitives.TemplateData(impl.templateData())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendTemplatedEmailRequest
  ): zio.aws.ses.model.SendTemplatedEmailRequest.ReadOnly = new Wrapper(impl)
}
