package zio.aws.ses.model
import zio.aws.ses.model.primitives.CustomRedirectDomain
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TrackingOptions(
    customRedirectDomain: Optional[CustomRedirectDomain] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.TrackingOptions = {
    import TrackingOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.TrackingOptions
      .builder()
      .optionallyWith(
        customRedirectDomain.map(value =>
          CustomRedirectDomain.unwrap(value): java.lang.String
        )
      )(_.customRedirectDomain)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.TrackingOptions.ReadOnly =
    zio.aws.ses.model.TrackingOptions.wrap(buildAwsValue())
}
object TrackingOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.TrackingOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.TrackingOptions = zio.aws.ses.model
      .TrackingOptions(customRedirectDomain.map(value => value))
    def customRedirectDomain: Optional[CustomRedirectDomain]
    def getCustomRedirectDomain: ZIO[Any, AwsError, CustomRedirectDomain] =
      AwsError.unwrapOptionField("customRedirectDomain", customRedirectDomain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.TrackingOptions
  ) extends zio.aws.ses.model.TrackingOptions.ReadOnly {
    override val customRedirectDomain: Optional[CustomRedirectDomain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customRedirectDomain())
        .map(value => zio.aws.ses.model.primitives.CustomRedirectDomain(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.TrackingOptions
  ): zio.aws.ses.model.TrackingOptions.ReadOnly = new Wrapper(impl)
}
