package zio.aws.ses.model
import zio.aws.ses.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateConfigurationSetTrackingOptionsRequest(
    configurationSetName: ConfigurationSetName,
    trackingOptions: zio.aws.ses.model.TrackingOptions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest = {
    import UpdateConfigurationSetTrackingOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .trackingOptions(trackingOptions.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.UpdateConfigurationSetTrackingOptionsRequest.ReadOnly =
    zio.aws.ses.model.UpdateConfigurationSetTrackingOptionsRequest
      .wrap(buildAwsValue())
}
object UpdateConfigurationSetTrackingOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.UpdateConfigurationSetTrackingOptionsRequest =
      zio.aws.ses.model.UpdateConfigurationSetTrackingOptionsRequest(
        configurationSetName,
        trackingOptions.asEditable
      )
    def configurationSetName: ConfigurationSetName
    def trackingOptions: zio.aws.ses.model.TrackingOptions.ReadOnly
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getTrackingOptions
        : ZIO[Any, Nothing, zio.aws.ses.model.TrackingOptions.ReadOnly] =
      ZIO.succeed(trackingOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest
  ) extends zio.aws.ses.model.UpdateConfigurationSetTrackingOptionsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.ses.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val trackingOptions: zio.aws.ses.model.TrackingOptions.ReadOnly =
      zio.aws.ses.model.TrackingOptions.wrap(impl.trackingOptions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.UpdateConfigurationSetTrackingOptionsRequest
  ): zio.aws.ses.model.UpdateConfigurationSetTrackingOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
