package zio.aws.ses.model
import zio.aws.ses.model.primitives.ReceiptRuleSetName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateReceiptRuleRequest(
    ruleSetName: ReceiptRuleSetName,
    rule: zio.aws.ses.model.ReceiptRule
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.UpdateReceiptRuleRequest = {
    import UpdateReceiptRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.UpdateReceiptRuleRequest
      .builder()
      .ruleSetName(ReceiptRuleSetName.unwrap(ruleSetName): java.lang.String)
      .rule(rule.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ses.model.UpdateReceiptRuleRequest.ReadOnly =
    zio.aws.ses.model.UpdateReceiptRuleRequest.wrap(buildAwsValue())
}
object UpdateReceiptRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.UpdateReceiptRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.UpdateReceiptRuleRequest =
      zio.aws.ses.model.UpdateReceiptRuleRequest(ruleSetName, rule.asEditable)
    def ruleSetName: ReceiptRuleSetName
    def rule: zio.aws.ses.model.ReceiptRule.ReadOnly
    def getRuleSetName: ZIO[Any, Nothing, ReceiptRuleSetName] =
      ZIO.succeed(ruleSetName)
    def getRule: ZIO[Any, Nothing, zio.aws.ses.model.ReceiptRule.ReadOnly] =
      ZIO.succeed(rule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.UpdateReceiptRuleRequest
  ) extends zio.aws.ses.model.UpdateReceiptRuleRequest.ReadOnly {
    override val ruleSetName: ReceiptRuleSetName =
      zio.aws.ses.model.primitives.ReceiptRuleSetName(impl.ruleSetName())
    override val rule: zio.aws.ses.model.ReceiptRule.ReadOnly =
      zio.aws.ses.model.ReceiptRule.wrap(impl.rule())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.UpdateReceiptRuleRequest
  ): zio.aws.ses.model.UpdateReceiptRuleRequest.ReadOnly = new Wrapper(impl)
}
