package zio.aws.ses.model
import zio.aws.ses.model.primitives.Domain
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VerifyDomainDkimRequest(domain: Domain) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.VerifyDomainDkimRequest = {
    import VerifyDomainDkimRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.VerifyDomainDkimRequest
      .builder()
      .domain(Domain.unwrap(domain): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.VerifyDomainDkimRequest.ReadOnly =
    zio.aws.ses.model.VerifyDomainDkimRequest.wrap(buildAwsValue())
}
object VerifyDomainDkimRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.VerifyDomainDkimRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.VerifyDomainDkimRequest =
      zio.aws.ses.model.VerifyDomainDkimRequest(domain)
    def domain: Domain
    def getDomain: ZIO[Any, Nothing, Domain] = ZIO.succeed(domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.VerifyDomainDkimRequest
  ) extends zio.aws.ses.model.VerifyDomainDkimRequest.ReadOnly {
    override val domain: Domain =
      zio.aws.ses.model.primitives.Domain(impl.domain())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.VerifyDomainDkimRequest
  ): zio.aws.ses.model.VerifyDomainDkimRequest.ReadOnly = new Wrapper(impl)
}
