package zio.aws.ses.model
import scala.jdk.CollectionConverters.*
sealed trait BulkEmailStatus {
  def unwrap: software.amazon.awssdk.services.ses.model.BulkEmailStatus
}
object BulkEmailStatus {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.BulkEmailStatus
  ): zio.aws.ses.model.BulkEmailStatus = value match {
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.MESSAGE_REJECTED =>
      val r = MessageRejected
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.MAIL_FROM_DOMAIN_NOT_VERIFIED =>
      val r = MailFromDomainNotVerified
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.CONFIGURATION_SET_DOES_NOT_EXIST =>
      val r = ConfigurationSetDoesNotExist
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.TEMPLATE_DOES_NOT_EXIST =>
      val r = TemplateDoesNotExist
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.ACCOUNT_SUSPENDED =>
      val r = AccountSuspended
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.ACCOUNT_THROTTLED =>
      val r = AccountThrottled
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.ACCOUNT_DAILY_QUOTA_EXCEEDED =>
      val r = AccountDailyQuotaExceeded
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.INVALID_SENDING_POOL_NAME =>
      val r = InvalidSendingPoolName
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.ACCOUNT_SENDING_PAUSED =>
      val r = AccountSendingPaused
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.CONFIGURATION_SET_SENDING_PAUSED =>
      val r = ConfigurationSetSendingPaused
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.INVALID_PARAMETER_VALUE =>
      val r = InvalidParameterValue
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.TRANSIENT_FAILURE =>
      val r = TransientFailure
      r
    case software.amazon.awssdk.services.ses.model.BulkEmailStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Success extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.SUCCESS
  }
  case object MessageRejected extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.MESSAGE_REJECTED
  }
  case object MailFromDomainNotVerified
      extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.MAIL_FROM_DOMAIN_NOT_VERIFIED
  }
  case object ConfigurationSetDoesNotExist
      extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.CONFIGURATION_SET_DOES_NOT_EXIST
  }
  case object TemplateDoesNotExist extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.TEMPLATE_DOES_NOT_EXIST
  }
  case object AccountSuspended extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.ACCOUNT_SUSPENDED
  }
  case object AccountThrottled extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.ACCOUNT_THROTTLED
  }
  case object AccountDailyQuotaExceeded
      extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.ACCOUNT_DAILY_QUOTA_EXCEEDED
  }
  case object InvalidSendingPoolName extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.INVALID_SENDING_POOL_NAME
  }
  case object AccountSendingPaused extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.ACCOUNT_SENDING_PAUSED
  }
  case object ConfigurationSetSendingPaused
      extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.CONFIGURATION_SET_SENDING_PAUSED
  }
  case object InvalidParameterValue extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.INVALID_PARAMETER_VALUE
  }
  case object TransientFailure extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.TRANSIENT_FAILURE
  }
  case object Failed extends zio.aws.ses.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BulkEmailStatus =
      software.amazon.awssdk.services.ses.model.BulkEmailStatus.FAILED
  }
}
