package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CloudWatchDestination(
    dimensionConfigurations: Iterable[
      zio.aws.ses.model.CloudWatchDimensionConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.CloudWatchDestination = {
    import CloudWatchDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.CloudWatchDestination
      .builder()
      .dimensionConfigurations(dimensionConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.CloudWatchDestination.ReadOnly =
    zio.aws.ses.model.CloudWatchDestination.wrap(buildAwsValue())
}
object CloudWatchDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.CloudWatchDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.CloudWatchDestination =
      zio.aws.ses.model.CloudWatchDestination(dimensionConfigurations.map {
        item =>
          item.asEditable
      })
    def dimensionConfigurations
        : List[zio.aws.ses.model.CloudWatchDimensionConfiguration.ReadOnly]
    def getDimensionConfigurations: ZIO[Any, Nothing, List[
      zio.aws.ses.model.CloudWatchDimensionConfiguration.ReadOnly
    ]] = ZIO.succeed(dimensionConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.CloudWatchDestination
  ) extends zio.aws.ses.model.CloudWatchDestination.ReadOnly {
    override val dimensionConfigurations
        : List[zio.aws.ses.model.CloudWatchDimensionConfiguration.ReadOnly] =
      impl
        .dimensionConfigurations()
        .asScala
        .map { item =>
          zio.aws.ses.model.CloudWatchDimensionConfiguration.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.CloudWatchDestination
  ): zio.aws.ses.model.CloudWatchDestination.ReadOnly = new Wrapper(impl)
}
