package zio.aws.ses.model
import zio.aws.ses.model.primitives.Identity
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetIdentityNotificationAttributesRequest(
    identities: Iterable[Identity]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesRequest = {
    import GetIdentityNotificationAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesRequest
      .builder()
      .identities(identities.map { item =>
        Identity.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.GetIdentityNotificationAttributesRequest.ReadOnly =
    zio.aws.ses.model.GetIdentityNotificationAttributesRequest
      .wrap(buildAwsValue())
}
object GetIdentityNotificationAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.GetIdentityNotificationAttributesRequest =
      zio.aws.ses.model.GetIdentityNotificationAttributesRequest(identities)
    def identities: List[Identity]
    def getIdentities: ZIO[Any, Nothing, List[Identity]] =
      ZIO.succeed(identities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesRequest
  ) extends zio.aws.ses.model.GetIdentityNotificationAttributesRequest.ReadOnly {
    override val identities: List[Identity] = impl
      .identities()
      .asScala
      .map { item =>
        zio.aws.ses.model.primitives.Identity(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesRequest
  ): zio.aws.ses.model.GetIdentityNotificationAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
