package zio.aws.ses.model
import zio.aws.ses.model.primitives.{PolicyName, Identity}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetIdentityPoliciesRequest(
    identity: Identity,
    policyNames: Iterable[PolicyName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetIdentityPoliciesRequest = {
    import GetIdentityPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetIdentityPoliciesRequest
      .builder()
      .identity(Identity.unwrap(identity): java.lang.String)
      .policyNames(policyNames.map { item =>
        PolicyName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.GetIdentityPoliciesRequest.ReadOnly =
    zio.aws.ses.model.GetIdentityPoliciesRequest.wrap(buildAwsValue())
}
object GetIdentityPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetIdentityPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.GetIdentityPoliciesRequest =
      zio.aws.ses.model.GetIdentityPoliciesRequest(identity, policyNames)
    def identity: Identity
    def policyNames: List[PolicyName]
    def getIdentity: ZIO[Any, Nothing, Identity] = ZIO.succeed(identity)
    def getPolicyNames: ZIO[Any, Nothing, List[PolicyName]] =
      ZIO.succeed(policyNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityPoliciesRequest
  ) extends zio.aws.ses.model.GetIdentityPoliciesRequest.ReadOnly {
    override val identity: Identity =
      zio.aws.ses.model.primitives.Identity(impl.identity())
    override val policyNames: List[PolicyName] = impl
      .policyNames()
      .asScala
      .map { item =>
        zio.aws.ses.model.primitives.PolicyName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityPoliciesRequest
  ): zio.aws.ses.model.GetIdentityPoliciesRequest.ReadOnly = new Wrapper(impl)
}
