package zio.aws.ses.model
import zio.aws.ses.model.primitives.VerificationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IdentityVerificationAttributes(
    verificationStatus: zio.aws.ses.model.VerificationStatus,
    verificationToken: Optional[VerificationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.IdentityVerificationAttributes = {
    import IdentityVerificationAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.IdentityVerificationAttributes
      .builder()
      .verificationStatus(verificationStatus.unwrap)
      .optionallyWith(
        verificationToken.map(value =>
          VerificationToken.unwrap(value): java.lang.String
        )
      )(_.verificationToken)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.IdentityVerificationAttributes.ReadOnly =
    zio.aws.ses.model.IdentityVerificationAttributes.wrap(buildAwsValue())
}
object IdentityVerificationAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.IdentityVerificationAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.IdentityVerificationAttributes =
      zio.aws.ses.model.IdentityVerificationAttributes(
        verificationStatus,
        verificationToken.map(value => value)
      )
    def verificationStatus: zio.aws.ses.model.VerificationStatus
    def verificationToken: Optional[VerificationToken]
    def getVerificationStatus
        : ZIO[Any, Nothing, zio.aws.ses.model.VerificationStatus] =
      ZIO.succeed(verificationStatus)
    def getVerificationToken: ZIO[Any, AwsError, VerificationToken] =
      AwsError.unwrapOptionField("verificationToken", verificationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.IdentityVerificationAttributes
  ) extends zio.aws.ses.model.IdentityVerificationAttributes.ReadOnly {
    override val verificationStatus: zio.aws.ses.model.VerificationStatus =
      zio.aws.ses.model.VerificationStatus.wrap(impl.verificationStatus())
    override val verificationToken: Optional[VerificationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verificationToken())
        .map(value => zio.aws.ses.model.primitives.VerificationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.IdentityVerificationAttributes
  ): zio.aws.ses.model.IdentityVerificationAttributes.ReadOnly = new Wrapper(
    impl
  )
}
