package zio.aws.ses.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ses.model.primitives.{MaxResults, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCustomVerificationEmailTemplatesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest = {
    import ListCustomVerificationEmailTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.ListCustomVerificationEmailTemplatesRequest.ReadOnly =
    zio.aws.ses.model.ListCustomVerificationEmailTemplatesRequest
      .wrap(buildAwsValue())
}
object ListCustomVerificationEmailTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.ListCustomVerificationEmailTemplatesRequest =
      zio.aws.ses.model.ListCustomVerificationEmailTemplatesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest
  ) extends zio.aws.ses.model.ListCustomVerificationEmailTemplatesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ses.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ses.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesRequest
  ): zio.aws.ses.model.ListCustomVerificationEmailTemplatesRequest.ReadOnly =
    new Wrapper(impl)
}
