package zio.aws.ses.model
import zio.aws.ses.model.primitives.{Policy, PolicyName, Identity}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutIdentityPolicyRequest(
    identity: Identity,
    policyName: PolicyName,
    policy: Policy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.PutIdentityPolicyRequest = {
    import PutIdentityPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.PutIdentityPolicyRequest
      .builder()
      .identity(Identity.unwrap(identity): java.lang.String)
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .policy(Policy.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.PutIdentityPolicyRequest.ReadOnly =
    zio.aws.ses.model.PutIdentityPolicyRequest.wrap(buildAwsValue())
}
object PutIdentityPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.PutIdentityPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.PutIdentityPolicyRequest =
      zio.aws.ses.model.PutIdentityPolicyRequest(identity, policyName, policy)
    def identity: Identity
    def policyName: PolicyName
    def policy: Policy
    def getIdentity: ZIO[Any, Nothing, Identity] = ZIO.succeed(identity)
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getPolicy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.PutIdentityPolicyRequest
  ) extends zio.aws.ses.model.PutIdentityPolicyRequest.ReadOnly {
    override val identity: Identity =
      zio.aws.ses.model.primitives.Identity(impl.identity())
    override val policyName: PolicyName =
      zio.aws.ses.model.primitives.PolicyName(impl.policyName())
    override val policy: Policy =
      zio.aws.ses.model.primitives.Policy(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.PutIdentityPolicyRequest
  ): zio.aws.ses.model.PutIdentityPolicyRequest.ReadOnly = new Wrapper(impl)
}
