package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SendBulkTemplatedEmailResponse(
    status: Iterable[zio.aws.ses.model.BulkEmailDestinationStatus]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailResponse = {
    import SendBulkTemplatedEmailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailResponse
      .builder()
      .status(status.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SendBulkTemplatedEmailResponse.ReadOnly =
    zio.aws.ses.model.SendBulkTemplatedEmailResponse.wrap(buildAwsValue())
}
object SendBulkTemplatedEmailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendBulkTemplatedEmailResponse =
      zio.aws.ses.model.SendBulkTemplatedEmailResponse(status.map { item =>
        item.asEditable
      })
    def status: List[zio.aws.ses.model.BulkEmailDestinationStatus.ReadOnly]
    def getStatus: ZIO[Any, Nothing, List[
      zio.aws.ses.model.BulkEmailDestinationStatus.ReadOnly
    ]] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailResponse
  ) extends zio.aws.ses.model.SendBulkTemplatedEmailResponse.ReadOnly {
    override val status
        : List[zio.aws.ses.model.BulkEmailDestinationStatus.ReadOnly] = impl
      .status()
      .asScala
      .map { item =>
        zio.aws.ses.model.BulkEmailDestinationStatus.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailResponse
  ): zio.aws.ses.model.SendBulkTemplatedEmailResponse.ReadOnly = new Wrapper(
    impl
  )
}
