package zio.aws.ses.model
import scala.jdk.CollectionConverters.*
sealed trait StopScope {
  def unwrap: software.amazon.awssdk.services.ses.model.StopScope
}
object StopScope {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.StopScope
  ): zio.aws.ses.model.StopScope = value match {
    case software.amazon.awssdk.services.ses.model.StopScope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.StopScope.RULE_SET =>
      val r = RuleSet
      r
  }
  case object unknownToSdkVersion extends zio.aws.ses.model.StopScope {
    override def unwrap: software.amazon.awssdk.services.ses.model.StopScope =
      software.amazon.awssdk.services.ses.model.StopScope.UNKNOWN_TO_SDK_VERSION
  }
  case object RuleSet extends zio.aws.ses.model.StopScope {
    override def unwrap: software.amazon.awssdk.services.ses.model.StopScope =
      software.amazon.awssdk.services.ses.model.StopScope.RULE_SET
  }
}
