package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{
  BlacklistingDescription,
  Timestamp,
  RblName
}
import scala.jdk.CollectionConverters.*
final case class BlacklistEntry(
    rblName: Optional[RblName] = Optional.Absent,
    listingTime: Optional[Timestamp] = Optional.Absent,
    description: Optional[BlacklistingDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.BlacklistEntry = {
    import BlacklistEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.BlacklistEntry
      .builder()
      .optionallyWith(
        rblName.map(value => RblName.unwrap(value): java.lang.String)
      )(_.rblName)
      .optionallyWith(
        listingTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.listingTime)
      .optionallyWith(
        description.map(value =>
          BlacklistingDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.BlacklistEntry.ReadOnly =
    zio.aws.sesv2.model.BlacklistEntry.wrap(buildAwsValue())
}
object BlacklistEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.BlacklistEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.BlacklistEntry =
      zio.aws.sesv2.model.BlacklistEntry(
        rblName.map(value => value),
        listingTime.map(value => value),
        description.map(value => value)
      )
    def rblName: Optional[RblName]
    def listingTime: Optional[Timestamp]
    def description: Optional[BlacklistingDescription]
    def getRblName: ZIO[Any, AwsError, RblName] =
      AwsError.unwrapOptionField("rblName", rblName)
    def getListingTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("listingTime", listingTime)
    def getDescription: ZIO[Any, AwsError, BlacklistingDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.BlacklistEntry
  ) extends zio.aws.sesv2.model.BlacklistEntry.ReadOnly {
    override val rblName: Optional[RblName] = zio.aws.core.internal
      .optionalFromNullable(impl.rblName())
      .map(value => zio.aws.sesv2.model.primitives.RblName(value))
    override val listingTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.listingTime())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val description: Optional[BlacklistingDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sesv2.model.primitives.BlacklistingDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.BlacklistEntry
  ): zio.aws.sesv2.model.BlacklistEntry.ReadOnly = new Wrapper(impl)
}
