package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BulkEmailEntry(
    destination: zio.aws.sesv2.model.Destination,
    replacementTags: Optional[Iterable[zio.aws.sesv2.model.MessageTag]] =
      Optional.Absent,
    replacementEmailContent: Optional[
      zio.aws.sesv2.model.ReplacementEmailContent
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.BulkEmailEntry = {
    import BulkEmailEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.BulkEmailEntry
      .builder()
      .destination(destination.buildAwsValue())
      .optionallyWith(
        replacementTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replacementTags)
      .optionallyWith(
        replacementEmailContent.map(value => value.buildAwsValue())
      )(_.replacementEmailContent)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.BulkEmailEntry.ReadOnly =
    zio.aws.sesv2.model.BulkEmailEntry.wrap(buildAwsValue())
}
object BulkEmailEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.BulkEmailEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.BulkEmailEntry =
      zio.aws.sesv2.model.BulkEmailEntry(
        destination.asEditable,
        replacementTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replacementEmailContent.map(value => value.asEditable)
      )
    def destination: zio.aws.sesv2.model.Destination.ReadOnly
    def replacementTags: Optional[List[zio.aws.sesv2.model.MessageTag.ReadOnly]]
    def replacementEmailContent
        : Optional[zio.aws.sesv2.model.ReplacementEmailContent.ReadOnly]
    def getDestination
        : ZIO[Any, Nothing, zio.aws.sesv2.model.Destination.ReadOnly] =
      ZIO.succeed(destination)
    def getReplacementTags
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.MessageTag.ReadOnly]] =
      AwsError.unwrapOptionField("replacementTags", replacementTags)
    def getReplacementEmailContent: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.ReplacementEmailContent.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replacementEmailContent",
      replacementEmailContent
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.BulkEmailEntry
  ) extends zio.aws.sesv2.model.BulkEmailEntry.ReadOnly {
    override val destination: zio.aws.sesv2.model.Destination.ReadOnly =
      zio.aws.sesv2.model.Destination.wrap(impl.destination())
    override val replacementTags
        : Optional[List[zio.aws.sesv2.model.MessageTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replacementTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.MessageTag.wrap(item)
          }.toList
        )
    override val replacementEmailContent
        : Optional[zio.aws.sesv2.model.ReplacementEmailContent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replacementEmailContent())
        .map(value => zio.aws.sesv2.model.ReplacementEmailContent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.BulkEmailEntry
  ): zio.aws.sesv2.model.BulkEmailEntry.ReadOnly = new Wrapper(impl)
}
