package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait BulkEmailStatus {
  def unwrap: software.amazon.awssdk.services.sesv2.model.BulkEmailStatus
}
object BulkEmailStatus {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.BulkEmailStatus
  ): zio.aws.sesv2.model.BulkEmailStatus = value match {
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.MESSAGE_REJECTED =>
      val r = MESSAGE_REJECTED
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.MAIL_FROM_DOMAIN_NOT_VERIFIED =>
      val r = MAIL_FROM_DOMAIN_NOT_VERIFIED
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.CONFIGURATION_SET_NOT_FOUND =>
      val r = CONFIGURATION_SET_NOT_FOUND
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.TEMPLATE_NOT_FOUND =>
      val r = TEMPLATE_NOT_FOUND
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.ACCOUNT_SUSPENDED =>
      val r = ACCOUNT_SUSPENDED
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.ACCOUNT_THROTTLED =>
      val r = ACCOUNT_THROTTLED
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.ACCOUNT_DAILY_QUOTA_EXCEEDED =>
      val r = ACCOUNT_DAILY_QUOTA_EXCEEDED
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.INVALID_SENDING_POOL_NAME =>
      val r = INVALID_SENDING_POOL_NAME
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.ACCOUNT_SENDING_PAUSED =>
      val r = ACCOUNT_SENDING_PAUSED
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.CONFIGURATION_SET_SENDING_PAUSED =>
      val r = CONFIGURATION_SET_SENDING_PAUSED
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.INVALID_PARAMETER =>
      val r = INVALID_PARAMETER
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.TRANSIENT_FAILURE =>
      val r = TRANSIENT_FAILURE
      r
    case software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.SUCCESS
  }
  case object MESSAGE_REJECTED extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.MESSAGE_REJECTED
  }
  case object MAIL_FROM_DOMAIN_NOT_VERIFIED
      extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.MAIL_FROM_DOMAIN_NOT_VERIFIED
  }
  case object CONFIGURATION_SET_NOT_FOUND
      extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.CONFIGURATION_SET_NOT_FOUND
  }
  case object TEMPLATE_NOT_FOUND extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.TEMPLATE_NOT_FOUND
  }
  case object ACCOUNT_SUSPENDED extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.ACCOUNT_SUSPENDED
  }
  case object ACCOUNT_THROTTLED extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.ACCOUNT_THROTTLED
  }
  case object ACCOUNT_DAILY_QUOTA_EXCEEDED
      extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.ACCOUNT_DAILY_QUOTA_EXCEEDED
  }
  case object INVALID_SENDING_POOL_NAME
      extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.INVALID_SENDING_POOL_NAME
  }
  case object ACCOUNT_SENDING_PAUSED
      extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.ACCOUNT_SENDING_PAUSED
  }
  case object CONFIGURATION_SET_SENDING_PAUSED
      extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.CONFIGURATION_SET_SENDING_PAUSED
  }
  case object INVALID_PARAMETER extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.INVALID_PARAMETER
  }
  case object TRANSIENT_FAILURE extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.TRANSIENT_FAILURE
  }
  case object FAILED extends zio.aws.sesv2.model.BulkEmailStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.BulkEmailStatus =
      software.amazon.awssdk.services.sesv2.model.BulkEmailStatus.FAILED
  }
}
