package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{Timestamp, ContactListName}
import scala.jdk.CollectionConverters.*
final case class ContactList(
    contactListName: Optional[ContactListName] = Optional.Absent,
    lastUpdatedTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ContactList = {
    import ContactList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ContactList
      .builder()
      .optionallyWith(
        contactListName.map(value =>
          ContactListName.unwrap(value): java.lang.String
        )
      )(_.contactListName)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ContactList.ReadOnly =
    zio.aws.sesv2.model.ContactList.wrap(buildAwsValue())
}
object ContactList {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.ContactList] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ContactList =
      zio.aws.sesv2.model.ContactList(
        contactListName.map(value => value),
        lastUpdatedTimestamp.map(value => value)
      )
    def contactListName: Optional[ContactListName]
    def lastUpdatedTimestamp: Optional[Timestamp]
    def getContactListName: ZIO[Any, AwsError, ContactListName] =
      AwsError.unwrapOptionField("contactListName", contactListName)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ContactList
  ) extends zio.aws.sesv2.model.ContactList.ReadOnly {
    override val contactListName: Optional[ContactListName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactListName())
        .map(value => zio.aws.sesv2.model.primitives.ContactListName(value))
    override val lastUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ContactList
  ): zio.aws.sesv2.model.ContactList.ReadOnly = new Wrapper(impl)
}
