package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Policy, PolicyName, Identity}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateEmailIdentityPolicyRequest(
    emailIdentity: Identity,
    policyName: PolicyName,
    policy: Policy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyRequest = {
    import CreateEmailIdentityPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .policy(Policy.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.CreateEmailIdentityPolicyRequest.ReadOnly =
    zio.aws.sesv2.model.CreateEmailIdentityPolicyRequest.wrap(buildAwsValue())
}
object CreateEmailIdentityPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CreateEmailIdentityPolicyRequest =
      zio.aws.sesv2.model
        .CreateEmailIdentityPolicyRequest(emailIdentity, policyName, policy)
    def emailIdentity: Identity
    def policyName: PolicyName
    def policy: Policy
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getPolicy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyRequest
  ) extends zio.aws.sesv2.model.CreateEmailIdentityPolicyRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.emailIdentity())
    override val policyName: PolicyName =
      zio.aws.sesv2.model.primitives.PolicyName(impl.policyName())
    override val policy: Policy =
      zio.aws.sesv2.model.primitives.Policy(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityPolicyRequest
  ): zio.aws.sesv2.model.CreateEmailIdentityPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
