package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.EmailTemplateName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCustomVerificationEmailTemplateRequest(
    templateName: EmailTemplateName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateRequest = {
    import DeleteCustomVerificationEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateRequest
      .builder()
      .templateName(EmailTemplateName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateRequest.ReadOnly =
    zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateRequest
      .wrap(buildAwsValue())
}
object DeleteCustomVerificationEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateRequest =
      zio.aws.sesv2.model
        .DeleteCustomVerificationEmailTemplateRequest(templateName)
    def templateName: EmailTemplateName
    def getTemplateName: ZIO[Any, Nothing, EmailTemplateName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateRequest
  ) extends zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateRequest.ReadOnly {
    override val templateName: EmailTemplateName =
      zio.aws.sesv2.model.primitives.EmailTemplateName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteCustomVerificationEmailTemplateRequest
  ): zio.aws.sesv2.model.DeleteCustomVerificationEmailTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
