package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{PolicyName, Identity}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteEmailIdentityPolicyRequest(
    emailIdentity: Identity,
    policyName: PolicyName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyRequest = {
    import DeleteEmailIdentityPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.DeleteEmailIdentityPolicyRequest.ReadOnly =
    zio.aws.sesv2.model.DeleteEmailIdentityPolicyRequest.wrap(buildAwsValue())
}
object DeleteEmailIdentityPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DeleteEmailIdentityPolicyRequest =
      zio.aws.sesv2.model
        .DeleteEmailIdentityPolicyRequest(emailIdentity, policyName)
    def emailIdentity: Identity
    def policyName: PolicyName
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyRequest
  ) extends zio.aws.sesv2.model.DeleteEmailIdentityPolicyRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.emailIdentity())
    override val policyName: PolicyName =
      zio.aws.sesv2.model.primitives.PolicyName(impl.policyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityPolicyRequest
  ): zio.aws.sesv2.model.DeleteEmailIdentityPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
