package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Identity
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteEmailIdentityRequest(emailIdentity: Identity) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityRequest = {
    import DeleteEmailIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DeleteEmailIdentityRequest.ReadOnly =
    zio.aws.sesv2.model.DeleteEmailIdentityRequest.wrap(buildAwsValue())
}
object DeleteEmailIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DeleteEmailIdentityRequest =
      zio.aws.sesv2.model.DeleteEmailIdentityRequest(emailIdentity)
    def emailIdentity: Identity
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityRequest
  ) extends zio.aws.sesv2.model.DeleteEmailIdentityRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.emailIdentity())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityRequest
  ): zio.aws.sesv2.model.DeleteEmailIdentityRequest.ReadOnly = new Wrapper(impl)
}
