package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.EmailAddress
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSuppressedDestinationRequest(
    emailAddress: EmailAddress
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationRequest = {
    import DeleteSuppressedDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationRequest
      .builder()
      .emailAddress(EmailAddress.unwrap(emailAddress): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.DeleteSuppressedDestinationRequest.ReadOnly =
    zio.aws.sesv2.model.DeleteSuppressedDestinationRequest.wrap(buildAwsValue())
}
object DeleteSuppressedDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DeleteSuppressedDestinationRequest =
      zio.aws.sesv2.model.DeleteSuppressedDestinationRequest(emailAddress)
    def emailAddress: EmailAddress
    def getEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(emailAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationRequest
  ) extends zio.aws.sesv2.model.DeleteSuppressedDestinationRequest.ReadOnly {
    override val emailAddress: EmailAddress =
      zio.aws.sesv2.model.primitives.EmailAddress(impl.emailAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteSuppressedDestinationRequest
  ): zio.aws.sesv2.model.DeleteSuppressedDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
