package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait DimensionValueSource {
  def unwrap: software.amazon.awssdk.services.sesv2.model.DimensionValueSource
}
object DimensionValueSource {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.DimensionValueSource
  ): zio.aws.sesv2.model.DimensionValueSource = value match {
    case software.amazon.awssdk.services.sesv2.model.DimensionValueSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.DimensionValueSource.MESSAGE_TAG =>
      val r = MESSAGE_TAG
      r
    case software.amazon.awssdk.services.sesv2.model.DimensionValueSource.EMAIL_HEADER =>
      val r = EMAIL_HEADER
      r
    case software.amazon.awssdk.services.sesv2.model.DimensionValueSource.LINK_TAG =>
      val r = LINK_TAG
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sesv2.model.DimensionValueSource {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.DimensionValueSource =
      software.amazon.awssdk.services.sesv2.model.DimensionValueSource.UNKNOWN_TO_SDK_VERSION
  }
  case object MESSAGE_TAG extends zio.aws.sesv2.model.DimensionValueSource {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.DimensionValueSource =
      software.amazon.awssdk.services.sesv2.model.DimensionValueSource.MESSAGE_TAG
  }
  case object EMAIL_HEADER extends zio.aws.sesv2.model.DimensionValueSource {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.DimensionValueSource =
      software.amazon.awssdk.services.sesv2.model.DimensionValueSource.EMAIL_HEADER
  }
  case object LINK_TAG extends zio.aws.sesv2.model.DimensionValueSource {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.DimensionValueSource =
      software.amazon.awssdk.services.sesv2.model.DimensionValueSource.LINK_TAG
  }
}
