package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait EventType {
  def unwrap: software.amazon.awssdk.services.sesv2.model.EventType
}
object EventType {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.EventType
  ): zio.aws.sesv2.model.EventType = value match {
    case software.amazon.awssdk.services.sesv2.model.EventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.EventType.SEND =>
      val r = SEND
      r
    case software.amazon.awssdk.services.sesv2.model.EventType.REJECT =>
      val r = REJECT
      r
    case software.amazon.awssdk.services.sesv2.model.EventType.BOUNCE =>
      val r = BOUNCE
      r
    case software.amazon.awssdk.services.sesv2.model.EventType.COMPLAINT =>
      val r = COMPLAINT
      r
    case software.amazon.awssdk.services.sesv2.model.EventType.DELIVERY =>
      val r = DELIVERY
      r
    case software.amazon.awssdk.services.sesv2.model.EventType.OPEN =>
      val r = OPEN
      r
    case software.amazon.awssdk.services.sesv2.model.EventType.CLICK =>
      val r = CLICK
      r
    case software.amazon.awssdk.services.sesv2.model.EventType.RENDERING_FAILURE =>
      val r = RENDERING_FAILURE
      r
    case software.amazon.awssdk.services.sesv2.model.EventType.DELIVERY_DELAY =>
      val r = DELIVERY_DELAY
      r
    case software.amazon.awssdk.services.sesv2.model.EventType.SUBSCRIPTION =>
      val r = SUBSCRIPTION
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.EventType =
      software.amazon.awssdk.services.sesv2.model.EventType.UNKNOWN_TO_SDK_VERSION
  }
  case object SEND extends zio.aws.sesv2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.EventType =
      software.amazon.awssdk.services.sesv2.model.EventType.SEND
  }
  case object REJECT extends zio.aws.sesv2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.EventType =
      software.amazon.awssdk.services.sesv2.model.EventType.REJECT
  }
  case object BOUNCE extends zio.aws.sesv2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.EventType =
      software.amazon.awssdk.services.sesv2.model.EventType.BOUNCE
  }
  case object COMPLAINT extends zio.aws.sesv2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.EventType =
      software.amazon.awssdk.services.sesv2.model.EventType.COMPLAINT
  }
  case object DELIVERY extends zio.aws.sesv2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.EventType =
      software.amazon.awssdk.services.sesv2.model.EventType.DELIVERY
  }
  case object OPEN extends zio.aws.sesv2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.EventType =
      software.amazon.awssdk.services.sesv2.model.EventType.OPEN
  }
  case object CLICK extends zio.aws.sesv2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.EventType =
      software.amazon.awssdk.services.sesv2.model.EventType.CLICK
  }
  case object RENDERING_FAILURE extends zio.aws.sesv2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.EventType =
      software.amazon.awssdk.services.sesv2.model.EventType.RENDERING_FAILURE
  }
  case object DELIVERY_DELAY extends zio.aws.sesv2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.EventType =
      software.amazon.awssdk.services.sesv2.model.EventType.DELIVERY_DELAY
  }
  case object SUBSCRIPTION extends zio.aws.sesv2.model.EventType {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.EventType =
      software.amazon.awssdk.services.sesv2.model.EventType.SUBSCRIPTION
  }
}
