package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.BlacklistItemName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetBlacklistReportsRequest(
    blacklistItemNames: Iterable[BlacklistItemName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsRequest = {
    import GetBlacklistReportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsRequest
      .builder()
      .blacklistItemNames(blacklistItemNames.map { item =>
        BlacklistItemName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetBlacklistReportsRequest.ReadOnly =
    zio.aws.sesv2.model.GetBlacklistReportsRequest.wrap(buildAwsValue())
}
object GetBlacklistReportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetBlacklistReportsRequest =
      zio.aws.sesv2.model.GetBlacklistReportsRequest(blacklistItemNames)
    def blacklistItemNames: List[BlacklistItemName]
    def getBlacklistItemNames: ZIO[Any, Nothing, List[BlacklistItemName]] =
      ZIO.succeed(blacklistItemNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsRequest
  ) extends zio.aws.sesv2.model.GetBlacklistReportsRequest.ReadOnly {
    override val blacklistItemNames: List[BlacklistItemName] = impl
      .blacklistItemNames()
      .asScala
      .map { item =>
        zio.aws.sesv2.model.primitives.BlacklistItemName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsRequest
  ): zio.aws.sesv2.model.GetBlacklistReportsRequest.ReadOnly = new Wrapper(impl)
}
