package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDedicatedIpResponse(
    dedicatedIp: Optional[zio.aws.sesv2.model.DedicatedIp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetDedicatedIpResponse = {
    import GetDedicatedIpResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetDedicatedIpResponse
      .builder()
      .optionallyWith(dedicatedIp.map(value => value.buildAwsValue()))(
        _.dedicatedIp
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetDedicatedIpResponse.ReadOnly =
    zio.aws.sesv2.model.GetDedicatedIpResponse.wrap(buildAwsValue())
}
object GetDedicatedIpResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetDedicatedIpResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetDedicatedIpResponse =
      zio.aws.sesv2.model
        .GetDedicatedIpResponse(dedicatedIp.map(value => value.asEditable))
    def dedicatedIp: Optional[zio.aws.sesv2.model.DedicatedIp.ReadOnly]
    def getDedicatedIp
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DedicatedIp.ReadOnly] =
      AwsError.unwrapOptionField("dedicatedIp", dedicatedIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetDedicatedIpResponse
  ) extends zio.aws.sesv2.model.GetDedicatedIpResponse.ReadOnly {
    override val dedicatedIp
        : Optional[zio.aws.sesv2.model.DedicatedIp.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedIp())
        .map(value => zio.aws.sesv2.model.DedicatedIp.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetDedicatedIpResponse
  ): zio.aws.sesv2.model.GetDedicatedIpResponse.ReadOnly = new Wrapper(impl)
}
