package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDedicatedIpsResponse(
    dedicatedIps: Optional[Iterable[zio.aws.sesv2.model.DedicatedIp]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse = {
    import GetDedicatedIpsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse
      .builder()
      .optionallyWith(
        dedicatedIps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dedicatedIps)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetDedicatedIpsResponse.ReadOnly =
    zio.aws.sesv2.model.GetDedicatedIpsResponse.wrap(buildAwsValue())
}
object GetDedicatedIpsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetDedicatedIpsResponse =
      zio.aws.sesv2.model.GetDedicatedIpsResponse(
        dedicatedIps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dedicatedIps: Optional[List[zio.aws.sesv2.model.DedicatedIp.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDedicatedIps
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.DedicatedIp.ReadOnly]] =
      AwsError.unwrapOptionField("dedicatedIps", dedicatedIps)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse
  ) extends zio.aws.sesv2.model.GetDedicatedIpsResponse.ReadOnly {
    override val dedicatedIps
        : Optional[List[zio.aws.sesv2.model.DedicatedIp.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedIps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.DedicatedIp.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse
  ): zio.aws.sesv2.model.GetDedicatedIpsResponse.ReadOnly = new Wrapper(impl)
}
