package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDomainStatisticsReportResponse(
    overallVolume: zio.aws.sesv2.model.OverallVolume,
    dailyVolumes: Iterable[zio.aws.sesv2.model.DailyVolume]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportResponse = {
    import GetDomainStatisticsReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportResponse
      .builder()
      .overallVolume(overallVolume.buildAwsValue())
      .dailyVolumes(dailyVolumes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.GetDomainStatisticsReportResponse.ReadOnly =
    zio.aws.sesv2.model.GetDomainStatisticsReportResponse.wrap(buildAwsValue())
}
object GetDomainStatisticsReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetDomainStatisticsReportResponse =
      zio.aws.sesv2.model.GetDomainStatisticsReportResponse(
        overallVolume.asEditable,
        dailyVolumes.map { item =>
          item.asEditable
        }
      )
    def overallVolume: zio.aws.sesv2.model.OverallVolume.ReadOnly
    def dailyVolumes: List[zio.aws.sesv2.model.DailyVolume.ReadOnly]
    def getOverallVolume
        : ZIO[Any, Nothing, zio.aws.sesv2.model.OverallVolume.ReadOnly] =
      ZIO.succeed(overallVolume)
    def getDailyVolumes
        : ZIO[Any, Nothing, List[zio.aws.sesv2.model.DailyVolume.ReadOnly]] =
      ZIO.succeed(dailyVolumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportResponse
  ) extends zio.aws.sesv2.model.GetDomainStatisticsReportResponse.ReadOnly {
    override val overallVolume: zio.aws.sesv2.model.OverallVolume.ReadOnly =
      zio.aws.sesv2.model.OverallVolume.wrap(impl.overallVolume())
    override val dailyVolumes: List[zio.aws.sesv2.model.DailyVolume.ReadOnly] =
      impl
        .dailyVolumes()
        .asScala
        .map { item =>
          zio.aws.sesv2.model.DailyVolume.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportResponse
  ): zio.aws.sesv2.model.GetDomainStatisticsReportResponse.ReadOnly =
    new Wrapper(impl)
}
