package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Policy, PolicyName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetEmailIdentityPoliciesResponse(
    policies: Optional[Map[PolicyName, Policy]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesResponse = {
    import GetEmailIdentityPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesResponse
      .builder()
      .optionallyWith(
        policies.map(value =>
          value
            .map({ case (key, value) =>
              (PolicyName.unwrap(key): java.lang.String) -> (Policy
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.policies)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.GetEmailIdentityPoliciesResponse.ReadOnly =
    zio.aws.sesv2.model.GetEmailIdentityPoliciesResponse.wrap(buildAwsValue())
}
object GetEmailIdentityPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetEmailIdentityPoliciesResponse =
      zio.aws.sesv2.model
        .GetEmailIdentityPoliciesResponse(policies.map(value => value))
    def policies: Optional[Map[PolicyName, Policy]]
    def getPolicies: ZIO[Any, AwsError, Map[PolicyName, Policy]] =
      AwsError.unwrapOptionField("policies", policies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesResponse
  ) extends zio.aws.sesv2.model.GetEmailIdentityPoliciesResponse.ReadOnly {
    override val policies: Optional[Map[PolicyName, Policy]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policies())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sesv2.model.primitives
                .PolicyName(key) -> zio.aws.sesv2.model.primitives.Policy(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailIdentityPoliciesResponse
  ): zio.aws.sesv2.model.GetEmailIdentityPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
