package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Identity
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetEmailIdentityRequest(emailIdentity: Identity) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetEmailIdentityRequest = {
    import GetEmailIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetEmailIdentityRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetEmailIdentityRequest.ReadOnly =
    zio.aws.sesv2.model.GetEmailIdentityRequest.wrap(buildAwsValue())
}
object GetEmailIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetEmailIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetEmailIdentityRequest =
      zio.aws.sesv2.model.GetEmailIdentityRequest(emailIdentity)
    def emailIdentity: Identity
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailIdentityRequest
  ) extends zio.aws.sesv2.model.GetEmailIdentityRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.emailIdentity())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailIdentityRequest
  ): zio.aws.sesv2.model.GetEmailIdentityRequest.ReadOnly = new Wrapper(impl)
}
