package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  ConfigurationSetName,
  Policy,
  PolicyName,
  Enabled
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetEmailIdentityResponse(
    identityType: Optional[zio.aws.sesv2.model.IdentityType] = Optional.Absent,
    feedbackForwardingStatus: Optional[Enabled] = Optional.Absent,
    verifiedForSendingStatus: Optional[Enabled] = Optional.Absent,
    dkimAttributes: Optional[zio.aws.sesv2.model.DkimAttributes] =
      Optional.Absent,
    mailFromAttributes: Optional[zio.aws.sesv2.model.MailFromAttributes] =
      Optional.Absent,
    policies: Optional[Map[PolicyName, Policy]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sesv2.model.Tag]] = Optional.Absent,
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent,
    verificationStatus: Optional[zio.aws.sesv2.model.VerificationStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse = {
    import GetEmailIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse
      .builder()
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        feedbackForwardingStatus.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.feedbackForwardingStatus)
      .optionallyWith(
        verifiedForSendingStatus.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.verifiedForSendingStatus)
      .optionallyWith(dkimAttributes.map(value => value.buildAwsValue()))(
        _.dkimAttributes
      )
      .optionallyWith(mailFromAttributes.map(value => value.buildAwsValue()))(
        _.mailFromAttributes
      )
      .optionallyWith(
        policies.map(value =>
          value
            .map({ case (key, value) =>
              (PolicyName.unwrap(key): java.lang.String) -> (Policy.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.policies)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .optionallyWith(verificationStatus.map(value => value.unwrap))(
        _.verificationStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetEmailIdentityResponse.ReadOnly =
    zio.aws.sesv2.model.GetEmailIdentityResponse.wrap(buildAwsValue())
}
object GetEmailIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetEmailIdentityResponse =
      zio.aws.sesv2.model.GetEmailIdentityResponse(
        identityType.map(value => value),
        feedbackForwardingStatus.map(value => value),
        verifiedForSendingStatus.map(value => value),
        dkimAttributes.map(value => value.asEditable),
        mailFromAttributes.map(value => value.asEditable),
        policies.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationSetName.map(value => value),
        verificationStatus.map(value => value)
      )
    def identityType: Optional[zio.aws.sesv2.model.IdentityType]
    def feedbackForwardingStatus: Optional[Enabled]
    def verifiedForSendingStatus: Optional[Enabled]
    def dkimAttributes: Optional[zio.aws.sesv2.model.DkimAttributes.ReadOnly]
    def mailFromAttributes
        : Optional[zio.aws.sesv2.model.MailFromAttributes.ReadOnly]
    def policies: Optional[Map[PolicyName, Policy]]
    def tags: Optional[List[zio.aws.sesv2.model.Tag.ReadOnly]]
    def configurationSetName: Optional[ConfigurationSetName]
    def verificationStatus: Optional[zio.aws.sesv2.model.VerificationStatus]
    def getIdentityType: ZIO[Any, AwsError, zio.aws.sesv2.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getFeedbackForwardingStatus: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("feedbackForwardingStatus", feedbackForwardingStatus)
    def getVerifiedForSendingStatus: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("verifiedForSendingStatus", verifiedForSendingStatus)
    def getDkimAttributes
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DkimAttributes.ReadOnly] =
      AwsError.unwrapOptionField("dkimAttributes", dkimAttributes)
    def getMailFromAttributes
        : ZIO[Any, AwsError, zio.aws.sesv2.model.MailFromAttributes.ReadOnly] =
      AwsError.unwrapOptionField("mailFromAttributes", mailFromAttributes)
    def getPolicies: ZIO[Any, AwsError, Map[PolicyName, Policy]] =
      AwsError.unwrapOptionField("policies", policies)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
    def getVerificationStatus
        : ZIO[Any, AwsError, zio.aws.sesv2.model.VerificationStatus] =
      AwsError.unwrapOptionField("verificationStatus", verificationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse
  ) extends zio.aws.sesv2.model.GetEmailIdentityResponse.ReadOnly {
    override val identityType: Optional[zio.aws.sesv2.model.IdentityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityType())
        .map(value => zio.aws.sesv2.model.IdentityType.wrap(value))
    override val feedbackForwardingStatus: Optional[Enabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.feedbackForwardingStatus())
        .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val verifiedForSendingStatus: Optional[Enabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedForSendingStatus())
        .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val dkimAttributes
        : Optional[zio.aws.sesv2.model.DkimAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dkimAttributes())
        .map(value => zio.aws.sesv2.model.DkimAttributes.wrap(value))
    override val mailFromAttributes
        : Optional[zio.aws.sesv2.model.MailFromAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mailFromAttributes())
        .map(value => zio.aws.sesv2.model.MailFromAttributes.wrap(value))
    override val policies: Optional[Map[PolicyName, Policy]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policies())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sesv2.model.primitives
                .PolicyName(key) -> zio.aws.sesv2.model.primitives.Policy(value)
            })
            .toMap
        )
    override val tags: Optional[List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.Tag.wrap(item)
          }.toList
        )
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value =>
          zio.aws.sesv2.model.primitives.ConfigurationSetName(value)
        )
    override val verificationStatus
        : Optional[zio.aws.sesv2.model.VerificationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verificationStatus())
        .map(value => zio.aws.sesv2.model.VerificationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse
  ): zio.aws.sesv2.model.GetEmailIdentityResponse.ReadOnly = new Wrapper(impl)
}
