package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.EmailTemplateName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetEmailTemplateRequest(templateName: EmailTemplateName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetEmailTemplateRequest = {
    import GetEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetEmailTemplateRequest
      .builder()
      .templateName(EmailTemplateName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetEmailTemplateRequest.ReadOnly =
    zio.aws.sesv2.model.GetEmailTemplateRequest.wrap(buildAwsValue())
}
object GetEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetEmailTemplateRequest =
      zio.aws.sesv2.model.GetEmailTemplateRequest(templateName)
    def templateName: EmailTemplateName
    def getTemplateName: ZIO[Any, Nothing, EmailTemplateName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailTemplateRequest
  ) extends zio.aws.sesv2.model.GetEmailTemplateRequest.ReadOnly {
    override val templateName: EmailTemplateName =
      zio.aws.sesv2.model.primitives.EmailTemplateName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetEmailTemplateRequest
  ): zio.aws.sesv2.model.GetEmailTemplateRequest.ReadOnly = new Wrapper(impl)
}
